<?php

include_once 'db.php';

// Start the session
session_start();
$user_id = $_SESSION['user_id'] ?? null;

// Set Content-Type header to application/json for API responses
header('Content-Type: application/json');

// Retrieve the raw JSON input
$inputJSON = file_get_contents('php://input');
$inputData = json_decode($inputJSON, true); // Decode JSON to an associative array

// Ensure the required variables are provided in the JSON payload
if (isset($inputData['stockinid']) && isset($inputData['qtyvaluetextbox'])) {
    $stockinid = $inputData['stockinid'];
    $qtyvaluetextbox = $inputData['qtyvaluetextbox'];

    // Start by updating the product table with the new quantity
    $sql = "UPDATE product SET qty = qty + $qtyvaluetextbox WHERE Product_id='$stockinid'";
    $sqlexecute = mysqli_query($conn, $sql);

    // Check if the query executed successfully
    if (!$sqlexecute) {
        echo json_encode(['status' => 'error', 'message' => 'Failed to update Product stock. MySQL Error: ' . mysqli_error($conn)]);
        exit; // Stop further execution if the update fails
    }

    // Now, check if the product exists in the inventory table
    $checkInventory = "SELECT * FROM inventory WHERE Product_id='$stockinid'";
    $inventoryResult = mysqli_query($conn, $checkInventory);

    if (mysqli_num_rows($inventoryResult) > 0) {
        // If the product exists in the inventory, update the quantity
        $updateInventory = "UPDATE inventory SET qty = qty + $qtyvaluetextbox, date_modified = NOW() WHERE Product_id='$stockinid'";
        $updateExecute = mysqli_query($conn, $updateInventory);

        if (!$updateExecute) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to update Inventory. MySQL Error: ' . mysqli_error($conn)]);
        } else {
            echo json_encode(['status' => 'success', 'message' => 'Inventory updated successfully.']);
        }
    } else {
        // If the product does not exist in the inventory, insert a new record
        $insertInventory = "INSERT INTO inventory (Product_id, Sku, Qty, date_added, date_modified, Location, Created_id,Editor_id) 
                            VALUES (
                                '$stockinid', 
                                (SELECT SKU FROM product WHERE Product_id='$stockinid'), 
                                (SELECT qty FROM product WHERE Product_id='$stockinid'), 
                                NOW(), 
                                NOW(),
                                (SELECT Location_rack FROM product WHERE Product_id='$stockinid'), 
                                '$user_id',
                                '$user_id'
                            )";

        $insertExecute = mysqli_query($conn, $insertInventory);

        if (!$insertExecute) {
            echo json_encode(['status' => 'error', 'message' => 'Failed to insert into Inventory. MySQL Error: ' . mysqli_error($conn)]);
        } else {
            echo json_encode(['status' => 'success', 'message' => 'Inventory inserted successfully.']);
        }
    }
} else {
    // Missing parameters in the JSON payload
    echo json_encode(['status' => 'error', 'message' => 'Required parameters are missing.']);
}

?>
